unit SAPILateBoundExampleForm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data;

type
  TSpeechForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    speechTextBox: System.Windows.Forms.TextBox;
    speakButton: System.Windows.Forms.Button;
    volumeButton: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure speakButton_Click(sender: System.Object; e: System.EventArgs);
    procedure volumeButton_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TSpeechForm))]

implementation

uses
  System.Reflection;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TSpeechForm.InitializeComponent;
begin
  Self.speechTextBox := System.Windows.Forms.TextBox.Create;
  Self.speakButton := System.Windows.Forms.Button.Create;
  Self.volumeButton := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // speechTextBox
  // 
  Self.speechTextBox.Location := System.Drawing.Point.Create(8, 8);
  Self.speechTextBox.Multiline := True;
  Self.speechTextBox.Name := 'speechTextBox';
  Self.speechTextBox.ScrollBars := System.Windows.Forms.ScrollBars.Vertical;
  Self.speechTextBox.Size := System.Drawing.Size.Create(544, 120);
  Self.speechTextBox.TabIndex := 0;
  Self.speechTextBox.Text := '<EMPH>Hello</EMPH>'#13#10'<PRON SYM="d eh l f y">Delphi</PRON> for .NET developers!'#13#10+ 
  '<VOLUME LEVEL="70">'#13#10'I can speak <PITCH MIDDLE="+10">high</PITCH> and <PITCH M'+ 
  'IDDLE="-10">low</PITCH>.'#13#10'I can speak <RATE SPEED="+10">very quickly</RATE> an'+ 
  'd <RATE SPEED="-10">very slowly</RATE>.'#13#10'I can speak <VOLUME LEVEL="40">quietl'+ 
  'y</VOLUME> and <VOLUME LEVEL="100">loudly</VOLUME>.'#13#10'</VOLUME>';
  // 
  // speakButton
  // 
  Self.speakButton.Location := System.Drawing.Point.Create(196, 136);
  Self.speakButton.Name := 'speakButton';
  Self.speakButton.TabIndex := 1;
  Self.speakButton.Text := '&Speak';
  Include(Self.speakButton.Click, Self.speakButton_Click);
  // 
  // volumeButton
  // 
  Self.volumeButton.Location := System.Drawing.Point.Create(289, 136);
  Self.volumeButton.Name := 'volumeButton';
  Self.volumeButton.TabIndex := 2;
  Self.volumeButton.Text := '&Volume';
  Include(Self.volumeButton.Click, Self.volumeButton_Click);
  // 
  // TSpeechForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(560, 166);
  Self.Controls.Add(Self.volumeButton);
  Self.Controls.Add(Self.speakButton);
  Self.Controls.Add(Self.speechTextBox);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedSingle;
  Self.Name := 'TSpeechForm';
  Self.Text := 'Microsoft Speech API Late Bound Example';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TSpeechForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TSpeechForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TSpeechForm.volumeButton_Click(sender: System.Object; e: System.EventArgs);
var
  VoiceType: &Type;
  Voice, AddlData: &Object;
  TwoArgs: array[1..2] of &Object;
  FourArgs: array[1..4] of &Object;
  ParamModifiers: array[0..0] of ParameterModifier;
const
  uiName = 'AudioVolume';
begin
  VoiceType := &Type.GetTypeFromProgID('SAPI.SpVoice');
  Voice := Activator.CreateInstance(VoiceType);
  AddlData := &Type.Missing;
  // Set up call with 1 value parameter and 1 reference parameter
  TwoArgs[1] := uiName;
  TwoArgs[2] := AddlData; // passed by reference
  ParamModifiers[0] := ParameterModifier.Create(2);
  ParamModifiers[0][0] := False; //1st arg is by value
  ParamModifiers[0][1] := True;  //2nd arg is by reference
  if Boolean(VoiceType.InvokeMember('IsUISupported',
    BindingFlags.InvokeMethod, nil, Voice, TwoArgs)) then
  begin
    // Set up call with 3 value parameters and 1 reference parameter
    FourArgs[1] := Handle;
    FourArgs[2] := '';
    FourArgs[3] := uiName;
    FourArgs[4] := AddlData; // passed by reference
    ParamModifiers[0] := ParameterModifier.Create(4);
    ParamModifiers[0][0] := False; //1st arg is by value
    ParamModifiers[0][1] := False; //2nd arg is by value
    ParamModifiers[0][2] := False; //3rd arg is by value
    ParamModifiers[0][3] := True;  //4th arg is by reference
    VoiceType.InvokeMember('DisplayUI',
      BindingFlags.InvokeMethod, nil, Voice, FourArgs)
  end
  else
    MessageBox.Show('No volume control support', 'Warning',
      MessageBoxButtons.OK, messageBoxIcon.Warning)
end;

procedure TSpeechForm.speakButton_Click(sender: System.Object; e: System.EventArgs);
var
  VoiceType: &Type;
  Voice: &Object;
  TwoArgs: array[1..2] of &Object;
begin
  VoiceType := &Type.GetTypeFromProgID('SAPI.SpVoice');
  Voice := Activator.CreateInstance(VoiceType);
  //Set up a call to a method with two value parameters
  TwoArgs[1] := speechTextBox.Text;
  TwoArgs[2] := 0; // SpeechVoiceSpeakFlags.SVSFDefault
  VoiceType.InvokeMember('Speak',
    BindingFlags.InvokeMethod, nil, Voice, TwoArgs);
end;

end.
